<?php
defined('PF_VERSION') OR exit('Access denied');
/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (vudoanthang83@gmail.com)
 * @copyright	PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
function load_admin_plugins($from_folder, $method = 'admin_init')
{
    if (is_dir($from_folder)) {
        if ($handle = @opendir($from_folder)) {
            while ($file = readdir($handle)) {
                if ((is_dir($from_folder . '/' . $file)) && ($file != '.') && ($file != '..') && ($file != '.svn')) {
                    if (is_file($from_folder . '/' . $file . '/' . $file . '.php')) {
                        require_once $from_folder . '/' . $file . '/' . $file . '.php';
                        $plugin = trim(strtolower($file));
                        load_language($plugin,'admin');
                        $plugin_names = explode('-', $plugin);
                        $plugin_names = array_map('strtolower', $plugin_names);
                        $plugin_names = array_map('ucfirst', $plugin_names);
                        $class = implode('_', $plugin_names) . '_Plugin';
                        if (class_exists($class)) {
                            $object = new $class ();
                            if (method_exists($object, $method)) {
                                $object->{$method}();
                            }

                        }
                    }
                }
            }
            closedir($handle);
        }

    }
}

function load_active_plugins($method = 'admin_init')
{
    $actived_plugins = get_option('active_plugins');
    if (!empty($actived_plugins)) {
        foreach ($actived_plugins as $plugin) {
            if (is_file(PLUGIN_PATH . '/' . $plugin)) {
                require PLUGIN_PATH . '/' . $plugin;

                $plugin = explode('/', trim($plugin));
                if (is_array($plugin) && count($plugin) == 2) {
                    $plugin_names = explode('-', $plugin [0]);
                    $plugin_names = array_map('strtolower', $plugin_names);
                    $plugin_names = array_map('ucfirst', $plugin_names);
                    $class = implode('_', $plugin_names) . '_Plugin';
                    load_language($plugin [0]);
                    if (class_exists($class)) {
                        $object = new $class ();
                        if (method_exists($object, $method)) {
                            $object->{$method}();
                        }

                    }
                }
            }
        }
    }
}

function get_plugins($from_folder)
{
    $plugins = array();

    if (is_dir($from_folder)) {
        if ($handle = @opendir($from_folder)) {
            while ($file = readdir($handle)) {
                if ((is_dir($from_folder . '/' . $file)) && ($file != '.') && ($file != '..') && ($file != '.svn')) {
                    if (is_file($from_folder . '/' . $file . '/' . $file . '.php')) {
                        $plugins [$file . '/' . $file . '.php'] = get_plugin_info($file, $from_folder . '/' . $file . '/' . $file . '.php');
                    }
                }
            }
            closedir($handle);
        }
    }

    return $plugins;
}

function get_plugin_info($plugin_name, $file)
{
    $plugin_info = array();
    $plugin_names = explode('-', $plugin_name);
    $plugin_names = array_map('strtolower', $plugin_names);
    $plugin_names = array_map('ucfirst', $plugin_names);
    $plugin_class = implode('_', $plugin_names) . '_Plugin';
    if (!class_exists($plugin_class)) {
        require $file;
    }
    $plugin_object = null;
    if (class_exists($plugin_class)) {
        $plugin_object = new $plugin_class(array(), array());
        if (!empty($plugin_object->name)) {
            $plugin_info ['name'] = $plugin_object->name;
            if (!empty($plugin_object->version)) {
                $plugin_info ['version'] = $plugin_object->version;
            }
            if (!empty($plugin_object->author)) {
                $plugin_info ['author'] = $plugin_object->author;
            }
            if (!empty($plugin_object->description)) {
                $plugin_info ['description'] = $plugin_object->description;
            }
        }
    }

    return $plugin_info;
}

function admin_css($link, $file = '')
{
    global $_admin_css;
    if ($file != '') {
        $file = preg_replace('/\\\/', '/', dirname($file));
    }
    $_admin_css [] = array(
        $link,
        $file
    );
}

function admin_js($js, $file = '')
{
    global $_admin_js;
    if ($file != '') {
        $file = preg_replace('/\\\/', '/', dirname($file));
    }
    $_admin_js [] = array(
        $js,
        $file
    );
}

/**
 *
 * @param string $name            
 * @param unknown $callback            
 * @param string $position_type            
 * @param string $position_menu            
 * @param string $parent_menu            
 */
function admin_menu($plugin_class, $icon_class, $name, $mnu_key, $callback = '', $parent_menu = '', $position_type = '', $position_menu = '')
{
    global $_admin_menu;

    $mnu_key = strtolower(trim(preg_replace('/[^a-zA-Z0-9]+/', '-', $mnu_key), '-'));

    if (!empty($parent_menu)) {
        $mnu_parent_key = strtolower(trim(preg_replace('/[^a-zA-Z0-9]+/', '-', $parent_menu), '-'));
        $_admin_menu [$mnu_parent_key] ['sub'] [$mnu_key] = array(
            'name' => $name,
            'plugin_class' => $plugin_class,
            'icon_class' => $icon_class,
            'callback' => $callback,
            'sub' => array()
        );
    } else {
        if (isset($_admin_menu [$mnu_key] ['sub'])) {
            $tmp = array(
                'name' => $name,
                'plugin_class' => $plugin_class,
                'icon_class' => $icon_class,
                'callback' => $callback,
                'sub' => $_admin_menu [$mnu_key] ['sub']
            );
            unset($_admin_menu [$mnu_key]);
            $_admin_menu [$mnu_key] = $tmp;
        } else {
            $_admin_menu [$mnu_key] = array(
                'name' => $name,
                'plugin_class' => $plugin_class,
                'icon_class' => $icon_class,
                'callback' => $callback,
                'sub' => array()
            );
        }
    }
}

function add_toolbar_button($form_button)
{
    global $_admin_toolbar_button;
    $_admin_toolbar_button [] = $form_button;
}

function array_move_element(&$array, $a, $b)
{
    $out = array_splice($array, $a, 1);
    array_splice($array, $b, 0, $out);
}

function is_login()
{
    $auth = Pf::auth();
    return $auth->is_logged_in();
}

function set_session($uid)
{
    $db = Pf::database();
    $db->select('user_name, user_displayname, user_role,pf_users.id as uid, user_avatar', 'pf_users', "pf_users.id='$uid'");
    $info = $db->fetch_assoc_all();
    $auth = Pf::auth();
    if (count($info) != 0) {
        $auth->set_session_info_login($info[0]);
    }
}
function current_user($field)
{
    $auth = Pf::auth();
    if (!is_null($auth->get_session('user-id'))) {
        $uid =  $auth->get_session('user-id');
        $db = Pf::database();
        if (!is_null($auth->get_session($field))){
            return $auth->get_session($field);
        }
        else {
            $db->select($field, 'pf_users', "`id`=? and user_delete_flag=0",array($uid));
            $info = $db->fetch_assoc_all();
            if (isset($info[0][$field]))
                return $info[0][$field];
            else
                return '';
        }
    } else
        return '';
}
function get_captcha() {
    $publickey = get_configuration('recaptcha_public_key');
    $privatekey = get_configuration('recaptcha_private_key');
    $captcha_enable = get_configuration('recaptcha_enable');
    $captcha_require = file_get_contents('http://www.google.com/recaptcha/api/challenge?k=' . $publickey);
    if (strpos($captcha_require, "Input error") > 0 || $captcha_enable!=1)
        $result	=	FALSE;
    else
    {
        $result= array(
            'publickey' =>  $publickey,
            'privatekey'=>  $privatekey
        );
    }
    return $result;
}
function notif($info) {
    if ($info) {
        $show = "<div class='alert alert-danger fade in'>
                 <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>×</button>
                 <strong>" . $info . "</strong>.
              </div>";
    } else {
        $show = '';
    }
    return $show;
}
function is_admin()
{
    $auth = Pf::auth();
    return $auth->is_admin();
}

function is_editor()
{
    $auth = Pf::auth();
    return $auth->is_editor();
}

function is_author()
{
    $auth = Pf::auth();
    return $auth->is_author();
}

function is_contributor()
{
    $auth = Pf::auth();
    return $auth->is_contributor();
}

function is_User()
{

    $auth = Pf::auth();
    return $auth->is_user();
}

function user_avatar($uid, $size = '80px', $class = '', $alt = '')
{
    if ($uid == current_user('user-id')) {
        $avatar = current_user('avatar');
        if ($alt == '') {
            $alt = current_user('user-displayname');
        }
    } else {
        Pf::database()->select('user_avatar,user_displayname', 'pf_users', "`id`='$uid'");
        $avatar_data = Pf::database()->fetch_assoc_all();
        $avatar = isset($avatar_data[0]['user_avatar']) ? $avatar_data[0]['user_avatar'] : '';
        if ($alt == '') {
            $alt = isset($avatar_data[0]['user_displayname']) ? $avatar_data[0]['user_displayname'] : '';
        }
    }
    if (!empty($avatar)) {
        return "<img src='" . site_url().RELATIVE_PATH.'/'.$avatar . "' style='width:" . $size . ";' class='" . $class . "' data-author='" . $alt . "' alt='" . $alt . "'/>";
    } else {
        return "<i class='fa fa-user fa-color $class' style='font-size:" . $size . "' data-author='" . $alt . "' ></i> ";
    }
}

function list_page()
{
    $db = Pf::database();
    $list = array();
    $db->select('page_url,page_title', 'pf_pages');
    $data = $db->fetch_assoc_all();
    if (!empty($data)) {
        foreach ($data as $item) {
            $list[$item['page_url']] = $item['page_title'];
        }
    }
    return $list;
}

function user_profile($username)
{
    $userpage = 'user';
    return RELATIVE_PATH . "/" . $userpage . "/page:profile/user:" . $username;
}

if(!function_exists('e')){
    function e($data) {
        $data = str_replace(array('&amp;', '&lt;', '&gt;'), array(
            '&amp;amp;', '&amp;lt;', '&amp;gt;'), $data);
        $data = preg_replace('/(&#*\w+)[\x00-\x20]+;/u', '$1;', $data);
        $data = preg_replace('/(&#x*[0-9A-F]+);*/iu', '$1;', $data);
        $data = html_entity_decode($data, ENT_COMPAT, 'UTF-8');
        $data = preg_replace('#(<[^>]+?[\x00-\x20"\'])(?:on|xmlns)[^>]*+>#iu', '$1>', $data);
        $data = preg_replace('#([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`\'"]*)[\x00-\x20]*j[\x00-\x20]*a[\x00-\x20]*v[\x00-\x20]*a[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2nojavascript...', $data);
        $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*v[\x00-\x20]*b[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20] *r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2novbscript...', $data);
        $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*-moz-binding[\x00-\x20]*:#u', '$1=$2nomozbinding...', $data);
        $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?expression[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
        $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?behaviour[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
        $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00- \x20]*:* [^>]*+>#iu', '$1>', $data);
        $data = preg_replace('#</*\w+:\w[^>]*+>#i', '', $data);
        do {
            $old_data = $data;
            $data = preg_replace('#</*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|i(?:frame|layer)|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|title|xml)[^>]*+>#i', '', $data);
        } while ($old_data !== $data);
        return $data;
    }

}
